/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.teco.shiva.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.util.QueryBuilder;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import ar.com.sdd.teco.shiva.core.TecoShivaConnectorContext;
import ar.com.sdd.teco.shiva.io.ConsultaClienteTecoShivaResponse;
import ar.com.sdd.teco.shiva.io.ConsultaDeudaTecoShivaRequest;
import ar.com.sdd.teco.shiva.io.ConsultaDeudaTecoShivaResponse;
import ar.com.sdd.teco.shiva.io.TecoShivaErrorResponse;
import ar.com.sdd.teco.shiva.io.TokenOAuth2Shiva;
import java.util.Date;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lar/com/sdd/teco/shiva/core/TecoShivaConnector;", "Lar/com/sdd/commons/rest/core/RestSecurityManager;", "context", "Lar/com/sdd/teco/shiva/core/TecoShivaConnectorContext;", "(Lar/com/sdd/teco/shiva/core/TecoShivaConnectorContext;)V", "log", "Lorg/apache/logging/log4j/Logger;", "log$1", "restConnector", "Lar/com/sdd/commons/rest/core/RestConnector;", "addHeaders", "Ljavax/ws/rs/client/Invocation$Builder;", "builder", "consultaCliente", "Lar/com/sdd/teco/shiva/io/ConsultaClienteTecoShivaResponse;", "tipoDocumento", "", "numeroDocumento", "consultaDeuda", "Lar/com/sdd/teco/shiva/io/ConsultaDeudaTecoShivaResponse;", "request", "Lar/com/sdd/teco/shiva/io/ConsultaDeudaTecoShivaRequest;", "getDisableHTTPSErrors", "", "Companion", "sdd.teco.shiva"})
public class TecoShivaConnector
implements RestSecurityManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger log$1;
    @NotNull
    private final RestConnector restConnector;
    @NotNull
    private final TecoShivaConnectorContext context;
    @NotNull
    private static final Logger log;
    @Nullable
    private static TokenOAuth2Shiva currentToken;
    @NotNull
    private static Date currentTokenExpires;

    public TecoShivaConnector(@NotNull TecoShivaConnectorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Logger logger = LogManager.getLogger(TecoShivaConnector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(TecoShivaConnector::class.java)");
        this.log$1 = logger;
        this.log$1.debug("Creando TecoShivaConnector para authUrl [" + context.getAuthUrl() + "], endpoint [" + context.getEndpointUrl() + "], user [" + context.getUser() + ']');
        this.context = context;
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getEndpointUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    @Nullable
    public Invocation.Builder addHeaders(@Nullable Invocation.Builder builder) throws RestConnectorException {
        block1: {
            if (Companion.cacheTokenIsExpired()) {
                this.log$1.debug("Recuperando Token. Timout previo [" + currentTokenExpires + ']');
                Form form = new Form();
                form.param("grant_type", "client_credentials");
                RestConnectorEnvironment environment = new RestConnectorEnvironment();
                environment.baseUrl = this.context.getAuthUrl();
                RestConnector connector2 = new RestConnector(environment, new RestSecurityManager(this){
                    final /* synthetic */ TecoShivaConnector this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    @NotNull
                    public Invocation.Builder addHeaders(@NotNull Invocation.Builder builder) {
                        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                        builder.header("Authorization", (Object)RestConnectorUtil.getBasicAuthHeader((String)TecoShivaConnector.access$getContext$p(this.this$0).getUser(), (String)TecoShivaConnector.access$getContext$p(this.this$0).getPass()));
                        return builder;
                    }

                    public boolean getDisableHTTPSErrors() {
                        return false;
                    }
                });
                TokenOAuth2Shiva tokenOAuth2Response = (TokenOAuth2Shiva)connector2.genericPost((Object)form, TokenOAuth2Shiva.class, "", "application/json", "application/x-www-form-urlencoded");
                this.log$1.debug("Token recuperado [" + tokenOAuth2Response + ']');
                Intrinsics.checkNotNullExpressionValue((Object)tokenOAuth2Response, (String)"tokenOAuth2Response");
                Companion.cacheSetToken(tokenOAuth2Response);
            }
            String idToken = Companion.cacheGetToken();
            Invocation.Builder builder2 = builder;
            if (builder2 == null) break block1;
            builder2.header("Authorization", (Object)("Bearer " + idToken));
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    @NotNull
    public final ConsultaClienteTecoShivaResponse consultaCliente(@NotNull String tipoDocumento, @NotNull String numeroDocumento) throws RestConnectorException {
        Intrinsics.checkNotNullParameter((Object)tipoDocumento, (String)"tipoDocumento");
        Intrinsics.checkNotNullParameter((Object)numeroDocumento, (String)"numeroDocumento");
        QueryBuilder queryBuilder = QueryBuilder.Builder().path("/cliente").add("tipoDocumento", tipoDocumento).add("numeroDocumento", numeroDocumento);
        Intrinsics.checkNotNullExpressionValue((Object)queryBuilder, (String)"Builder().path(\"/cliente\u2026umento\", numeroDocumento)");
        QueryBuilder queryBuilder2 = queryBuilder;
        String path = queryBuilder2.build();
        this.log$1.debug("[consultaClientes] Request GET cliente con tipoDocumento [" + tipoDocumento + "], numeroDocumento [" + numeroDocumento + "], path [" + path + ']');
        try {
            ConsultaClienteTecoShivaResponse response = (ConsultaClienteTecoShivaResponse)this.restConnector.genericGet(null, ConsultaClienteTecoShivaResponse.class, TecoShivaErrorResponse.class, path);
            this.log$1.debug("[consultaClientes] Response GET cliente [" + response + ']');
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
            return response;
        }
        catch (RestConnectorException restException) {
            if (restException.getEntityError() != null) {
                Object object = restException.getEntityError();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type ar.com.sdd.teco.shiva.io.TecoShivaErrorResponse");
                TecoShivaErrorResponse errorResponse = (TecoShivaErrorResponse)object;
                String string = errorResponse.getMensaje();
                boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Acceso denegado", (boolean)false, (int)2, null) : false;
                if (bl) {
                    Companion.cacheResetToken();
                    ConsultaClienteTecoShivaResponse response = (ConsultaClienteTecoShivaResponse)this.restConnector.genericGet(null, ConsultaClienteTecoShivaResponse.class, TecoShivaErrorResponse.class, path);
                    this.log$1.debug("[consultaClientes] Response GET cliente [" + response + ']');
                    Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                    return response;
                }
            }
            throw restException;
        }
    }

    @NotNull
    public final ConsultaDeudaTecoShivaResponse consultaDeuda(@NotNull ConsultaDeudaTecoShivaRequest request) throws RestConnectorException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String path = "/deuda";
        this.log$1.debug("[consultaDeuda] Request POST deuda con request [" + request + "], path [" + path + ']');
        try {
            ConsultaDeudaTecoShivaResponse response = (ConsultaDeudaTecoShivaResponse)this.restConnector.genericPost((Object)request, ConsultaDeudaTecoShivaResponse.class, TecoShivaErrorResponse.class, path);
            this.log$1.debug("[consultaDeuda] Response POST deuda [" + response + ']');
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
            return response;
        }
        catch (RestConnectorException restException) {
            if (restException.getEntityError() != null) {
                Object object = restException.getEntityError();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type ar.com.sdd.teco.shiva.io.TecoShivaErrorResponse");
                TecoShivaErrorResponse errorResponse = (TecoShivaErrorResponse)object;
                String string = errorResponse.getMensaje();
                boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Acceso denegado", (boolean)false, (int)2, null) : false;
                if (bl) {
                    Companion.cacheResetToken();
                    ConsultaDeudaTecoShivaResponse response = (ConsultaDeudaTecoShivaResponse)this.restConnector.genericPost((Object)request, ConsultaDeudaTecoShivaResponse.class, TecoShivaErrorResponse.class, path);
                    this.log$1.debug("[consultaDeuda] Response POST deuda [" + response + ']');
                    Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                    return response;
                }
            }
            throw restException;
        }
    }

    public static final /* synthetic */ TecoShivaConnectorContext access$getContext$p(TecoShivaConnector $this) {
        return $this.context;
    }

    static {
        Logger logger = LogManager.getLogger(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(TecoShivaConne\u2026or.Companion::class.java)");
        log = logger;
        currentTokenExpires = new Date();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0004J\u0006\u0010\u0017\u001a\u00020\u0018R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lar/com/sdd/teco/shiva/core/TecoShivaConnector$Companion;", "", "()V", "currentToken", "Lar/com/sdd/teco/shiva/io/TokenOAuth2Shiva;", "getCurrentToken", "()Lar/com/sdd/teco/shiva/io/TokenOAuth2Shiva;", "setCurrentToken", "(Lar/com/sdd/teco/shiva/io/TokenOAuth2Shiva;)V", "currentTokenExpires", "Ljava/util/Date;", "getCurrentTokenExpires", "()Ljava/util/Date;", "setCurrentTokenExpires", "(Ljava/util/Date;)V", "log", "Lorg/apache/logging/log4j/Logger;", "cacheGetToken", "", "cacheResetToken", "", "cacheSetToken", "token", "cacheTokenIsExpired", "", "sdd.teco.shiva"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final TokenOAuth2Shiva getCurrentToken() {
            return currentToken;
        }

        public final void setCurrentToken(@Nullable TokenOAuth2Shiva tokenOAuth2Shiva) {
            currentToken = tokenOAuth2Shiva;
        }

        @NotNull
        public final Date getCurrentTokenExpires() {
            return currentTokenExpires;
        }

        public final void setCurrentTokenExpires(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"<set-?>");
            currentTokenExpires = date;
        }

        public final void cacheResetToken() {
            log.debug("Reset Token. Timout previo [" + this.getCurrentTokenExpires() + ']');
            this.setCurrentToken(null);
            this.setCurrentTokenExpires(new Date());
        }

        public final boolean cacheTokenIsExpired() {
            return this.getCurrentToken() == null || this.getCurrentTokenExpires().before(new Date());
        }

        public final void cacheSetToken(@NotNull TokenOAuth2Shiva token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            this.setCurrentToken(token);
            TokenOAuth2Shiva tokenOAuth2Shiva = this.getCurrentToken();
            Intrinsics.checkNotNull((Object)tokenOAuth2Shiva);
            this.setCurrentTokenExpires(new Date((long)(tokenOAuth2Shiva.getExpiresIn() * 1000) + System.currentTimeMillis() - (long)1800000));
        }

        @NotNull
        public final String cacheGetToken() {
            TokenOAuth2Shiva tokenOAuth2Shiva = this.getCurrentToken();
            Intrinsics.checkNotNull((Object)tokenOAuth2Shiva);
            String string = tokenOAuth2Shiva.getIdToken();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentToken!!.idToken");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

