package ar.com.sdd.teco.shiva.model

import ar.com.sdd.teco.shiva.util.TecoAmountDeserializer
import ar.com.sdd.teco.shiva.util.TecoStringDeserializer
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import java.math.BigDecimal

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class ContratoResultado {
    @JsonDeserialize(using = TecoStringDeserializer::class)
    var contrato: String? = null

    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var saldo: BigDecimal? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var monedaImporteACobrar: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var marcaTasaCero: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var cantidadDeDias: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var marcaDA: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var descripcionDA: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var operacionAsociada: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var numeroReferencia: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var marcaReclamo: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var estadoOrigen: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var cliente: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var analista: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var fechaValor: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var claseComprobante: String? = null

    /*
    CC	Tipo de Comprobante Cuenta Corriente
    FAC	Tipo de Comprobante Factura
    DEB	Tipo de Comprobante Nota de Debito
    DUC	Tipo de Comprobante DUC
    */
    @JsonDeserialize(using = TecoStringDeserializer::class)
    var tipoComprobante: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var sucursalComprobante: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var idDocumentoCuentaCobranza: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var tipoDocumento: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var sistema: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var numeroComprobante: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var origen: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var estadoContrato: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var marcaPagoCompensacionEnProcesoShiva: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var marcaReversionDeCobroProcesoPendiente: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var marcaReversionDeCobroEdicion: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var moneda: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var sistemaOrigen: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var sociedad: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var estadoOrigenCodigo: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var operacionesAsociadasAnalista: String? = null

    //Pend: TECO-182: No se si estos campos existen del lado de contratos , o como se van a llamar
    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var importeEnDolares: BigDecimal? = null

    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var tasaCambio: BigDecimal? = null

    /*
    Color	Significado
    rojo	El documento no es gestionable.
    naranja	El documento no es gestionable.
    amarillo	El documento es gestionable pero pueden surgir errores.
    verde	El documento es gestionable.
    */
    var semaforoGestionabilidad: SemaforoGestionabilidad? = null
    override fun toString(): String {
        return "ContratoResultado(contrato=$contrato, saldo=$saldo, monedaImporteACobrar=$monedaImporteACobrar, marcaTasaCero=$marcaTasaCero, cantidadDeDias=$cantidadDeDias, marcaDA=$marcaDA, descripcionDA=$descripcionDA, operacionAsociada=$operacionAsociada, numeroReferencia=$numeroReferencia, marcaReclamo=$marcaReclamo, estadoOrigen=$estadoOrigen, cliente=$cliente, analista=$analista, fechaValor=$fechaValor, claseComprobante=$claseComprobante, tipoComprobante=$tipoComprobante, sucursalComprobante=$sucursalComprobante, idDocumentoCuentaCobranza=$idDocumentoCuentaCobranza, tipoDocumento=$tipoDocumento, sistema=$sistema, numeroComprobante=$numeroComprobante, origen=$origen, estadoContrato=$estadoContrato, marcaPagoCompensacionEnProcesoShiva=$marcaPagoCompensacionEnProcesoShiva, marcaReversionDeCobroProcesoPendiente=$marcaReversionDeCobroProcesoPendiente, marcaReversionDeCobroEdicion=$marcaReversionDeCobroEdicion, moneda=$moneda, sistemaOrigen=$sistemaOrigen, sociedad=$sociedad, estadoOrigenCodigo=$estadoOrigenCodigo, operacionesAsociadasAnalista=$operacionesAsociadasAnalista, importeEnDolares=$importeEnDolares, tasaCambio=$tasaCambio, semaforoGestionabilidad=$semaforoGestionabilidad)"
    }

}