package ar.com.sdd.teco.shiva.model

import ar.com.sdd.teco.shiva.util.TecoAmountDeserializer
import ar.com.sdd.teco.shiva.util.TecoDateDeserializer
import ar.com.sdd.teco.shiva.util.TecoStringDeserializer
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import java.math.BigDecimal
import java.util.*

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class DatosGestionCobranza {
    @JsonDeserialize(using = TecoStringDeserializer::class)
    var acuerdoFacturacion: String? = null

    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var saldoPesificadoFechaCotizacion: BigDecimal? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var tipoCambioFechaCotizacion: String? = null

    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var importePagoMinimo: BigDecimal? = null

    @JsonDeserialize(using = TecoDateDeserializer::class)
    var fechaVencimientoMora: Date? = null

    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var saldoPesificado: BigDecimal? = null

    @JsonDeserialize(using = TecoDateDeserializer::class)
    var fechaVencimiento: Date? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var estadoAcuerdoFacturacionCalipso: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var estadoAcuerdoFacturacionMic: String? = null

    @JsonDeserialize(using = TecoDateDeserializer::class)
    var fechaEmision: Date? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var tipoCambio: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var estadoContrato: String? = null

    @JsonDeserialize(using = TecoDateDeserializer::class)
    var fechaTipoCambio: Date? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var destransferirTerceros: String? = null

    @JsonDeserialize(using = TecoDateDeserializer::class)
    var fechaPuestaCobro: Date? = null

    @JsonDeserialize(using = TecoDateDeserializer::class)
    var fechaUltimoPagoParcial: Date? = null

    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var importeTercerosTransferidos: BigDecimal? = null

    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var saldoTerceroFinanciableTransferible: BigDecimal? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var moneda: String? = null

    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var importeAPrimerVencimiento: BigDecimal? = null

    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var importeASegundoVencimiento: BigDecimal? = null

    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var saldoPrimerVencimientoMonedaOrigen: BigDecimal? = null

    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var importePrimerVencimientoPesificado: BigDecimal? = null

    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var importePrimerVencimientoTerceros: BigDecimal? = null

    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var importeSegundoVencimientoTerceros: BigDecimal? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var estadoConceptosDeTerceros: String? = null

    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var importePrimerVencimientoPesificadoAFechaCotizacion: BigDecimal? = null

    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var saldoTerceroFinanciableNoTransferible: BigDecimal? = null

    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var saldoTerceroNoFinanciableTransferible: BigDecimal? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var sinDiferenciaDeCambio: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var cobrarAlSegundoVencimiento: String? = null

    //Pend: TECO-182: Ya definidos
    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var importeEnDolares: BigDecimal? = null

    @JsonDeserialize(using = TecoAmountDeserializer::class)
    var tasaCambio: BigDecimal? = null

    override fun toString(): String {
        return "DatosGestionCobranza(acuerdoFacturacion=$acuerdoFacturacion, saldoPesificadoFechaCotizacion=$saldoPesificadoFechaCotizacion, tipoCambioFechaCotizacion=$tipoCambioFechaCotizacion, importePagoMinimo=$importePagoMinimo, fechaVencimientoMora=$fechaVencimientoMora, saldoPesificado=$saldoPesificado, fechaVencimiento=$fechaVencimiento, estadoAcuerdoFacturacionCalipso=$estadoAcuerdoFacturacionCalipso, estadoAcuerdoFacturacionMic=$estadoAcuerdoFacturacionMic, fechaEmision=$fechaEmision, tipoCambio=$tipoCambio, estadoContrato=$estadoContrato, fechaTipoCambio=$fechaTipoCambio, destransferirTerceros=$destransferirTerceros, fechaPuestaCobro=$fechaPuestaCobro, fechaUltimoPagoParcial=$fechaUltimoPagoParcial, importeTercerosTransferidos=$importeTercerosTransferidos, saldoTerceroFinanciableTransferible=$saldoTerceroFinanciableTransferible, moneda=$moneda, importeAPrimerVencimiento=$importeAPrimerVencimiento, importeASegundoVencimiento=$importeASegundoVencimiento, saldoPrimerVencimientoMonedaOrigen=$saldoPrimerVencimientoMonedaOrigen, importePrimerVencimientoPesificado=$importePrimerVencimientoPesificado, importePrimerVencimientoTerceros=$importePrimerVencimientoTerceros, importeSegundoVencimientoTerceros=$importeSegundoVencimientoTerceros, estadoConceptosDeTerceros=$estadoConceptosDeTerceros, importePrimerVencimientoPesificadoAFechaCotizacion=$importePrimerVencimientoPesificadoAFechaCotizacion, saldoTerceroFinanciableNoTransferible=$saldoTerceroFinanciableNoTransferible, saldoTerceroNoFinanciableTransferible=$saldoTerceroNoFinanciableTransferible, sinDiferenciaDeCambio=$sinDiferenciaDeCambio, cobrarAlSegundoVencimiento=$cobrarAlSegundoVencimiento, importeEnDolares=$importeEnDolares,tasaCambio=$tasaCambio)"
    }
}