package ar.com.sdd.teco.shiva.model

import ar.com.sdd.teco.shiva.util.TecoStringDeserializer
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.databind.annotation.JsonDeserialize

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class DatosOrigenDocumento {

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var sistemaDescripcion: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var origen: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var sistemaOrigen: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var sociedad: String? = null

    override fun toString(): String {
        return "DatosOrigenDocumento(sistemaDescripcion=$sistemaDescripcion, origen=$origen, sistemaOrigen=$sistemaOrigen, sociedad=$sociedad)"
    }

}