package ar.com.sdd.teco.shiva.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown = true)
public class TokenOAuth2Shiva implements Serializable {

    @JsonProperty("access_token")
    private String accessToken = null;
    @JsonProperty("scope")
    private String scope = null;
    @JsonProperty("id_token")
    private String idToken = null;
    @JsonProperty("token_type")
    private String tokenType = null;
    @JsonProperty("expires_in")
    private Integer expiresIn = null;

    public TokenOAuth2Shiva() {

    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getIdToken() {
        return idToken;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    public String getTokenType() {
        return tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public Integer getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    @Override
    public String toString() {
        return "TokenOAuth2Shiva ["
                + ((accessToken != null) ? "accessToken=" + accessToken + ", " : "")
                + ((scope != null) ? "scope=" + scope + ", " : "")
                + ((idToken != null) ? "idToken=" + idToken + ", " : "")
                + ((tokenType != null) ? "tokenType=" + tokenType + ", " : "")
                + ((expiresIn != null) ? "expiresIn=" + expiresIn : "")
                + "]";
    }
}
