package ar.com.sdd.teco.shiva.model

import ar.com.sdd.teco.shiva.util.TecoStringDeserializer
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.databind.annotation.JsonDeserialize

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class DatosClaveDebito {

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var numeroReferenciaDuc: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var numeroReferencia: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var cuenta: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var cliente: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var claseComprobante: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var sucursalComprobante: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var idDocumentoCuentaCobranza: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var tipoDocumento: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var numeroComprobante: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var numeroDocumento: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var idContrato: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var tipoFactura: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var tipoComprobanteCodigo: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var tipoComprobanteDescripcion: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var numeroDocumentoLegalFormateado: String? = null

    override fun toString(): String {
        return "DatosClaveDebito(numeroReferenciaDuc=$numeroReferenciaDuc, numeroReferencia=$numeroReferencia, cuenta=$cuenta, cliente=$cliente, claseComprobante=$claseComprobante, sucursalComprobante=$sucursalComprobante, idDocumentoCuentaCobranza=$idDocumentoCuentaCobranza, tipoDocumento=$tipoDocumento, numeroComprobante=$numeroComprobante, numeroDocumento=$numeroDocumento, idContrato=$idContrato, tipoFactura=$tipoFactura, tipoComprobanteCodigo=$tipoComprobanteCodigo, tipoComprobanteDescripcion=$tipoComprobanteDescripcion, numeroDocumentoLegalFormateado=$numeroDocumentoLegalFormateado)"
    }

}