package ar.com.sdd.teco.shiva.model

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class Resultado {
    /*
    Interpretacion del atributo estado del objeto Resultado:
    Estado	Significado
    OK	En caso de que la consulta sea correcta, y existan resultados para los argumentos de busqueda.
    NOK	En caso de que la consulta sea correcta, pero no existan resultados para los argumentos de busqueda.
    WRN	En caso de que alguno de los sistemas legados haya fallado en entregar un resultado, pero se pudo retornar 'algo'.
    ERR	En caso de que no se hayan podido retornar resultados por errores internos.
    */
    var estado: String? = null
    var codigoDeError: String? = null
    var descripcionDelError: String? = null

    override fun toString(): String {
        return "Resultado(estado=$estado, codigoDeError=$codigoDeError, descripcionDelError=$descripcionDelError)"
    }

}