/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.teco.shiva.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.util.QueryBuilder;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import ar.com.sdd.commons.util.SimpleCache;
import ar.com.sdd.commons.util.SimpleCacheManager;
import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.teco.shiva.core.TecoShivaConnectorContext;
import ar.com.sdd.teco.shiva.io.ConsultaClienteTecoShivaResponse;
import ar.com.sdd.teco.shiva.io.ConsultaDeudaTecoShivaRequest;
import ar.com.sdd.teco.shiva.io.ConsultaDeudaTecoShivaResponse;
import ar.com.sdd.teco.shiva.io.TecoShivaErrorResponse;
import ar.com.sdd.teco.shiva.io.TokenOAuth2Shiva;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lar/com/sdd/teco/shiva/core/TecoShivaConnector;", "Lar/com/sdd/commons/rest/core/RestSecurityManager;", "context", "Lar/com/sdd/teco/shiva/core/TecoShivaConnectorContext;", "(Lar/com/sdd/teco/shiva/core/TecoShivaConnectorContext;)V", "log", "Lorg/apache/logging/log4j/Logger;", "restConnector", "Lar/com/sdd/commons/rest/core/RestConnector;", "addHeaders", "Ljavax/ws/rs/client/Invocation$Builder;", "builder", "consultaCliente", "Lar/com/sdd/teco/shiva/io/ConsultaClienteTecoShivaResponse;", "tipoDocumento", "", "numeroDocumento", "consultaDeuda", "Lar/com/sdd/teco/shiva/io/ConsultaDeudaTecoShivaResponse;", "request", "Lar/com/sdd/teco/shiva/io/ConsultaDeudaTecoShivaRequest;", "getAccessToken", "force", "", "getDisableHTTPSErrors", "retryOnUnauthorized", "sdd.teco.shiva"})
public class TecoShivaConnector
implements RestSecurityManager {
    @NotNull
    private final Logger log;
    @NotNull
    private final RestConnector restConnector;
    @NotNull
    private final TecoShivaConnectorContext context;

    public TecoShivaConnector(@NotNull TecoShivaConnectorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Logger logger = LogManager.getLogger(TecoShivaConnector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(TecoShivaConnector::class.java)");
        this.log = logger;
        this.log.debug("Creando TecoShivaConnector para authUrl [" + context.getAuthUrl() + "], endpoint [" + context.getEndpointUrl() + "], user [" + context.getUser() + ']');
        this.context = context;
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getEndpointUrl());
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    @Nullable
    public Invocation.Builder addHeaders(@Nullable Invocation.Builder builder) throws RestConnectorException {
        block0: {
            String idToken = this.getAccessToken(false);
            Invocation.Builder builder2 = builder;
            if (builder2 == null) break block0;
            builder2.header("Authorization", (Object)("Bearer " + idToken));
        }
        return builder;
    }

    @NotNull
    public final String getAccessToken(boolean force) {
        SimpleCache simpleCache = SimpleCacheManager.getInstance().getCache(TecoShivaConnector.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)simpleCache, (String)"getInstance().getCache(T\u2026or::class.java.getName())");
        SimpleCache cache = simpleCache;
        Object[] objectArray = new Object[]{"accessToken"};
        String cacheKey = SimpleCacheManager.buildKey((Object[])objectArray);
        Object accessToken = cache.get(cacheKey);
        if (force || accessToken == null) {
            this.log.debug("Recuperando Token.");
            Form form = new Form();
            form.param("grant_type", "client_credentials");
            form.param("scope", "openid");
            RestConnectorEnvironment environment = new RestConnectorEnvironment();
            environment.baseUrl = this.context.getAuthUrl();
            RestConnector connector2 = new RestConnector(environment, new RestSecurityManager(this){
                final /* synthetic */ TecoShivaConnector this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public Invocation.Builder addHeaders(@NotNull Invocation.Builder builder) {
                    Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                    if (!StringUtil.isEmpty((String)TecoShivaConnector.access$getContext$p(this.this$0).getCookie())) {
                        builder.header("Cookie", (Object)TecoShivaConnector.access$getContext$p(this.this$0).getCookie());
                    }
                    builder.header("Authorization", (Object)RestConnectorUtil.getBasicAuthHeader((String)TecoShivaConnector.access$getContext$p(this.this$0).getUser(), (String)TecoShivaConnector.access$getContext$p(this.this$0).getPass()));
                    return builder;
                }

                public boolean retryOnUnauthorized() {
                    return false;
                }

                public boolean getDisableHTTPSErrors() {
                    return true;
                }
            });
            TokenOAuth2Shiva tokenOAuth2Response = (TokenOAuth2Shiva)connector2.genericPost((Object)form, TokenOAuth2Shiva.class, "", "application/json", "application/x-www-form-urlencoded");
            this.log.debug("Token recuperado [" + tokenOAuth2Response + ']');
            accessToken = tokenOAuth2Response.getIdToken();
            cache.put(cacheKey, accessToken, tokenOAuth2Response.getExpiresIn());
        }
        Object object = accessToken;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    public boolean retryOnUnauthorized() {
        return false;
    }

    public boolean getDisableHTTPSErrors() {
        return true;
    }

    @NotNull
    public final ConsultaClienteTecoShivaResponse consultaCliente(@NotNull String tipoDocumento, @NotNull String numeroDocumento) throws RestConnectorException {
        Intrinsics.checkNotNullParameter((Object)tipoDocumento, (String)"tipoDocumento");
        Intrinsics.checkNotNullParameter((Object)numeroDocumento, (String)"numeroDocumento");
        QueryBuilder queryBuilder = QueryBuilder.Builder().path("/cliente").add("tipoDocumento", tipoDocumento).add("numeroDocumento", numeroDocumento);
        Intrinsics.checkNotNullExpressionValue((Object)queryBuilder, (String)"Builder().path(\"/cliente\u2026umento\", numeroDocumento)");
        QueryBuilder queryBuilder2 = queryBuilder;
        String path = queryBuilder2.build();
        this.log.debug("[consultaClientes] Request GET cliente con tipoDocumento [" + tipoDocumento + "], numeroDocumento [" + numeroDocumento + "], path [" + path + ']');
        try {
            ConsultaClienteTecoShivaResponse response = (ConsultaClienteTecoShivaResponse)this.restConnector.genericGet(null, ConsultaClienteTecoShivaResponse.class, TecoShivaErrorResponse.class, path);
            this.log.debug("[consultaClientes] Response GET cliente [" + response + ']');
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
            return response;
        }
        catch (RestConnectorException restException) {
            if (restException.getEntityError() != null) {
                Object object = restException.getEntityError();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type ar.com.sdd.teco.shiva.io.TecoShivaErrorResponse");
                TecoShivaErrorResponse errorResponse = (TecoShivaErrorResponse)object;
                String string = errorResponse.getMensaje();
                boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Acceso denegado", (boolean)false, (int)2, null) : false;
                if (bl) {
                    this.getAccessToken(true);
                    ConsultaClienteTecoShivaResponse response = (ConsultaClienteTecoShivaResponse)this.restConnector.genericGet(null, ConsultaClienteTecoShivaResponse.class, TecoShivaErrorResponse.class, path);
                    this.log.debug("[consultaClientes] Response GET cliente 2 [" + response + ']');
                    Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                    return response;
                }
            }
            throw restException;
        }
    }

    @NotNull
    public final ConsultaDeudaTecoShivaResponse consultaDeuda(@NotNull ConsultaDeudaTecoShivaRequest request) throws RestConnectorException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String path = "/deuda";
        this.log.debug("[consultaDeuda] Request POST deuda con request [" + request + "], path [" + path + ']');
        try {
            ConsultaDeudaTecoShivaResponse response = (ConsultaDeudaTecoShivaResponse)this.restConnector.genericPost((Object)request, ConsultaDeudaTecoShivaResponse.class, TecoShivaErrorResponse.class, path);
            this.log.debug("[consultaDeuda] Response POST deuda [{}]", (Object)response);
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
            return response;
        }
        catch (RestConnectorException restException) {
            if (restException.getEntityError() != null) {
                Object object = restException.getEntityError();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type ar.com.sdd.teco.shiva.io.TecoShivaErrorResponse");
                TecoShivaErrorResponse errorResponse = (TecoShivaErrorResponse)object;
                String string = errorResponse.getMensaje();
                boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Acceso denegado", (boolean)false, (int)2, null) : false;
                if (bl) {
                    this.getAccessToken(true);
                    ConsultaDeudaTecoShivaResponse response = (ConsultaDeudaTecoShivaResponse)this.restConnector.genericPost((Object)request, ConsultaDeudaTecoShivaResponse.class, TecoShivaErrorResponse.class, path);
                    this.log.debug("[consultaDeuda] Response POST deuda 2 [" + response + ']');
                    Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                    return response;
                }
            }
            throw restException;
        }
    }

    public static final /* synthetic */ TecoShivaConnectorContext access$getContext$p(TecoShivaConnector $this) {
        return $this.context;
    }
}

