package ar.com.sdd.teco.shiva.io

import ar.com.sdd.teco.shiva.model.Cliente
import ar.com.sdd.teco.shiva.model.PaginaSiguiente
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class ConsultaDeudaTecoShivaRequest {

    var clientes: List<Cliente>? = null
    var paginaCuentaCorriente: PaginaSiguiente? = null
    var paginaDebito: PaginaSiguiente? = null

    override fun toString(): String {
        return "ConsultaDeudaTecoShivaRequest(clientes=$clientes, paginaCuentaCorriente=$paginaCuentaCorriente, paginaDebito=$paginaDebito)"
    }

}