package ar.com.sdd.teco.shiva.model

import ar.com.sdd.teco.shiva.util.TecoStringDeserializer
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.databind.annotation.JsonDeserialize

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class Cliente {

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var empresasAsociadas: String? = null

    var sistemas: List<String>? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var codigoPostal: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var clienteOrigen: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var codigoHolding: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var agenciaNegocio: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var segmentoAgencia: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var idClienteLegado: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var tipoDocumento: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var razonSocial: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var descripcionHolding: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var descripcionAgenciaNegocio: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var idProvincia: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var origen: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var addressId: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var numeroDocumento: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var idClientePerfil: String? = null

    override fun toString(): String {
        return "Cliente(empresasAsociadas=$empresasAsociadas, sistemas=$sistemas, codigoPostal=$codigoPostal, clienteOrigen=$clienteOrigen, codigoHolding=$codigoHolding, agenciaNegocio=$agenciaNegocio, segmentoAgencia=$segmentoAgencia, idClienteLegado=$idClienteLegado, tipoDocumento=$tipoDocumento, razonSocial=$razonSocial, descripcionHolding=$descripcionHolding, descripcionAgenciaNegocio=$descripcionAgenciaNegocio, idProvincia=$idProvincia, origen=$origen, addressId=$addressId, numeroDocumento=$numeroDocumento, idClientePerfil=$idClientePerfil)"
    }
}