package ar.com.sdd.teco.shiva.model


import ar.com.sdd.teco.shiva.util.TecoStringDeserializer
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.databind.annotation.JsonDeserialize

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class DatosGestionAdminisrativa {

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var marcaApropiarDeimos: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var cuota: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var marcaTasaCero: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var descripcionDA: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var marcaCyq: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var marcaReclamo: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var codigoTarifa: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var indicadorPeticionCorte: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var marcaMigradoDeimos: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var razonSocialCliente: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var estadoMorosidad: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var estadoOrigen: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var marcaReclamoDescripcion: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var cuit: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var subtipoDocumento: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var subTipoDakota: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var numeroConvenio: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var unidadOperativa: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var holding: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var tipoCliente: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var migradoOrigen: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var cicloFacturacion: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var marketingCustomerGroup: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var tipoDuc: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var posibilidadDestransferencia: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var estadoDeimos: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var subtipoDocumentoDescripcion: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var marcaMigradaOrigen: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var estadoOrigenCodigo: String? = null

    override fun toString(): String {
        return "DatosGestionAdminisrativa(marcaApropiarDeimos=$marcaApropiarDeimos, cuota=$cuota, marcaTasaCero=$marcaTasaCero, descripcionDA=$descripcionDA, marcaCyq=$marcaCyq, marcaReclamo=$marcaReclamo, codigoTarifa=$codigoTarifa, indicadorPeticionCorte=$indicadorPeticionCorte, marcaMigradoDeimos=$marcaMigradoDeimos, razonSocialCliente=$razonSocialCliente, estadoMorosidad=$estadoMorosidad, estadoOrigen=$estadoOrigen, marcaReclamoDescripcion=$marcaReclamoDescripcion, cuit=$cuit, subtipoDocumento=$subtipoDocumento, subTipoDakota=$subTipoDakota, numeroConvenio=$numeroConvenio, unidadOperativa=$unidadOperativa, holding=$holding, tipoCliente=$tipoCliente, migradoOrigen=$migradoOrigen, cicloFacturacion=$cicloFacturacion, marketingCustomerGroup=$marketingCustomerGroup, tipoDuc=$tipoDuc, posibilidadDestransferencia=$posibilidadDestransferencia, estadoDeimos=$estadoDeimos, subtipoDocumentoDescripcion=$subtipoDocumentoDescripcion, marcaMigradaOrigen=$marcaMigradaOrigen, estadoOrigenCodigo=$estadoOrigenCodigo)"
    }

}