package ar.com.sdd.teco.shiva.model

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class PaginaSiguiente {

    var nroPagina: Long? = null
    var totalesPorSistema: TotalesPorSistema? = null
    var inicioPorSistema: InicioPorSistema? = null
    var referenciaPorSistema: ReferenciaPorSistema? = null
    var totalPaginas: Long? = null
    var cantPorPagina: Long? = null
    var totalRegistros: Long? = null
    var cantRegistrosMostrados: Long? = null

    override fun toString(): String {
        return "PaginaSiguiente(nroPagina=$nroPagina, totalesPorSistema=$totalesPorSistema, inicioPorSistema=$inicioPorSistema, referenciaPorSistema=$referenciaPorSistema, totalPaginas=$totalPaginas, cantPorPagina=$cantPorPagina, totalRegistros=$totalRegistros, cantRegistrosMostrados=$cantRegistrosMostrados)"
    }

}