package ar.com.sdd.teco.shiva.util

import com.fasterxml.jackson.core.JsonParser
import com.fasterxml.jackson.databind.DeserializationContext
import com.fasterxml.jackson.databind.deser.std.StdDeserializer
import java.math.BigDecimal
import java.text.NumberFormat
import java.util.*

/**
 * Convierte el formato de Teco de importes
 * Si viene, null, vacio o "-", devuelve null
 * Si viene un monto en formato argentino ("99.999,99"), lo convierte a BigDecimal
 *
 */
open class TecoAmountDeserializer : StdDeserializer<BigDecimal?>(BigDecimal::class.java) {

    override fun deserialize(jsonParser: JsonParser?, deserializationContext: DeserializationContext?): BigDecimal? {
        if (jsonParser != null) {
            val amountString = jsonParser.readValueAs(String::class.java)
            return if (amountString == null || amountString.trim() == "" || amountString.trim() == "-") {
                null
            } else {
                BigDecimal(numberFormat.parse(amountString).toString())
            }

        } else {
            throw Exception("jsonParser es null")
        }
    }

    companion object {
        val numberFormat: NumberFormat = NumberFormat.getInstance(Locale("es", "AR"))
    }
}