package ar.com.sdd.teco.shiva.model

import ar.com.sdd.teco.shiva.util.TecoStringDeserializer
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.databind.annotation.JsonDeserialize

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class DatosGestionDeimos {

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var deimosEstadoTramite: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var deimosApropiacionEnDeimos: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
        var deimosCantidadDeCuotas: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var deimosCantidadDeCuotasPagas: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var deimosNumeroConvenio: String? = null

    override fun toString(): String {
        return "DatosGestionDeimos(deimosEstadoTramite=$deimosEstadoTramite, deimosApropiacionEnDeimos=$deimosApropiacionEnDeimos, deimosCantidadDeCuotas=$deimosCantidadDeCuotas, deimosCantidadDeCuotasPagas=$deimosCantidadDeCuotasPagas, deimosNumeroConvenio=$deimosNumeroConvenio)"
    }

}