package ar.com.sdd.teco.shiva.model


import ar.com.sdd.teco.shiva.util.TecoStringDeserializer
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.databind.annotation.JsonDeserialize

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
open class DatosGestionShiva {

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var marcaPagoCompensacionEnProcesoShiva: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var documentoIncluidoEnOtraOperacionShivaEnEdicionEnum: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var marcaReversionDeCobroProcesoPendiente: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var marcaReversionDeCobroEdicion: String? = null

    @JsonDeserialize(using = TecoStringDeserializer::class)
    var operacionesAsociadasAnalista: String? = null

    override fun toString(): String {
        return "DatosGestionShiva(marcaPagoCompensacionEnProcesoShiva=$marcaPagoCompensacionEnProcesoShiva, documentoIncluidoEnOtraOperacionShivaEnEdicionEnum=$documentoIncluidoEnOtraOperacionShivaEnEdicionEnum, marcaReversionDeCobroProcesoPendiente=$marcaReversionDeCobroProcesoPendiente, marcaReversionDeCobroEdicion=$marcaReversionDeCobroEdicion, operacionesAsociadasAnalista=$operacionesAsociadasAnalista)"
    }

}