package ar.com.sdd.toyotaapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Cupon implements Serializable {

    @JsonProperty("numero_Cupon")
    private String numeroCupon;

    @JsonProperty("fecha_Vencimiento")
    private String fechaVencimiento;

    @JsonProperty("monto")
    private BigDecimal monto;

    @JsonProperty("numero_Cuota")
    private Integer numeroCuota;

    @JsonProperty("link")
    private String link;

    public String getNumeroCupon() {
        return numeroCupon;
    }

    public void setNumeroCupon(String numeroCupon) {
        this.numeroCupon = numeroCupon;
    }

    public String getFechaVencimiento() {
        return fechaVencimiento;
    }

    public void setFechaVencimiento(String fechaVencimiento) {
        this.fechaVencimiento = fechaVencimiento;
    }

    public BigDecimal getMonto() {
        return monto;
    }

    public void setMonto(BigDecimal monto) {
        this.monto = monto;
    }

    public Integer getNumeroCuota() {
        return numeroCuota;
    }

    public void setNumeroCuota(Integer numeroCuota) {
        this.numeroCuota = numeroCuota;
    }

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    @Override
    public String toString() {
        return "Cupon [" +
                ((numeroCupon != null) ? "numeroCupon='" + numeroCupon + "', " : "") +
                ((fechaVencimiento != null) ? "fechaVencimiento='" + fechaVencimiento + "', " : "") +
                ((monto != null) ? "monto=" + monto + ", " : "") +
                ((numeroCuota != null) ? "numeroCuota=" + numeroCuota + ", " : "") +
                ((link != null) ? "link='" + link + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Cupon cupon = (Cupon) o;
        return Objects.equals(numeroCupon, cupon.numeroCupon) && Objects.equals(fechaVencimiento, cupon.fechaVencimiento) && Objects.equals(monto, cupon.monto) && Objects.equals(numeroCuota, cupon.numeroCuota) && Objects.equals(link, cupon.link);
    }

    @Override
    public int hashCode() {
        return Objects.hash(numeroCupon, fechaVencimiento, monto, numeroCuota, link);
    }
}