package ar.com.sdd.toyotaapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import ar.com.sdd.toyotaapi.io.PostBillingListRequest;
import ar.com.sdd.toyotaapi.io.PostBillingListResponse;
import ar.com.sdd.toyotaapi.io.PostPaymentResponse;
import ar.com.sdd.toyotaapi.io.PostPaymentsRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.ws.rs.client.Invocation;

public class ToyotaApiConnector implements RestSecurityManager {

    private static final Logger log = LogManager.getLogger(ToyotaApiConnector.class);

    private final RestConnector connector;
    private final String username;
    private final String password;
    private final String apiKey;

    public ToyotaApiConnector(ToyotaApiConnectorContext context) {
        this.username = context.getUsername();
        this.password = context.getPassword();
        this.apiKey = context.getApiKey();

        log.trace("Creando BindApiConnector con {}", context);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        connector = new RestConnector(environment, this);
    }

    // ----------------------------- Billing List (Deuda) ----------------------------------------- //

    public PostBillingListResponse postBillingList(PostBillingListRequest postBillingListRequest) throws RestConnectorException {
        log.debug("Iniciando exportacion de deuda con request={}", postBillingListRequest);
        return connector.genericPost(postBillingListRequest, PostBillingListResponse.class, "/quotas/billinglist");
    }

    // ------------------------ Payments (Exportación de Pagos) ----------------------------------- //

    public PostPaymentResponse postPayment(PostPaymentsRequest postPaymentsRequest) throws RestConnectorException {
        log.debug("Iniciando exportacion de pagos con request={}", postPaymentsRequest);
        return connector.genericPost(postPaymentsRequest, PostPaymentResponse.class, "/payments");
    }

    // -------------------------------------------------------------------------------------------- //

    @Override
    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder = builder.header("Authorization", RestConnectorUtil.getBasicAuthHeader(username, password));
            builder = builder.header("X-TKNA", apiKey);
        }
        return builder;
    }

    @Override
    public boolean retryOnUnauthorized() {
        return false;
    }

    @Override
    public boolean getDisableHTTPSErrors() {
        return false;
    }
}