package ar.com.sdd.toyotaapi.io;

import ar.com.sdd.toyotaapi.model.Cupon;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostBillingListResponse implements Serializable {

    @JsonProperty("cupones")
    private List<Cupon> cupones;

    @JsonProperty("error_code")
    private Integer errorCode;

    @JsonProperty("tipo_Cupon")
    private String tipoCupon;

    @JsonProperty("mensaje")
    private String mensaje;

    public List<Cupon> getCupones() {
        return cupones;
    }

    public void setCupones(List<Cupon> cupones) {
        this.cupones = cupones;
    }

    public Integer getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public String getTipoCupon() {
        return tipoCupon;
    }

    public void setTipoCupon(String tipoCupon) {
        this.tipoCupon = tipoCupon;
    }

    public String getMensaje() {
        return mensaje;
    }

    public void setMensaje(String mensaje) {
        this.mensaje = mensaje;
    }

    @Override
    public String toString() {
        return "PostBillingListResponse [" +
                ((cupones != null) ? "cupones=" + Arrays.toString(cupones.toArray()) + ", " : "") +
                ((errorCode != null) ? "errorCode=" + errorCode + ", " : "") +
                ((tipoCupon != null) ? "tipoCupon='" + tipoCupon + "', " : "") +
                ((mensaje != null) ? "mensaje='" + mensaje + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostBillingListResponse that = (PostBillingListResponse) o;
        return Objects.equals(cupones, that.cupones) && Objects.equals(errorCode, that.errorCode) && Objects.equals(tipoCupon, that.tipoCupon) && Objects.equals(mensaje, that.mensaje);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cupones, errorCode, tipoCupon, mensaje);
    }
}
