package ar.com.sdd.toyotaapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostPaymentResponse implements Serializable {

    @JsonProperty("returnCode")
    private Integer returnCode;

    @JsonProperty("message")
    private String message;

    @JsonProperty("result")
    private Integer result;

    public Integer getReturnCode() {
        return returnCode;
    }

    public void setReturnCode(Integer returnCode) {
        this.returnCode = returnCode;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Integer getResult() {
        return result;
    }

    public void setResult(Integer result) {
        this.result = result;
    }

    @Override
    public String toString() {
        return "PostPaymentResponse [" +
                ((returnCode != null) ? "returnCode=" + returnCode + ", " : "") +
                ((message != null) ? "message='" + message + "', " : "") +
                ((result != null) ? "result=" + result + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostPaymentResponse that = (PostPaymentResponse) o;
        return Objects.equals(returnCode, that.returnCode) && Objects.equals(message, that.message) && Objects.equals(result, that.result);
    }

    @Override
    public int hashCode() {
        return Objects.hash(returnCode, message, result);
    }
}
