package ar.com.sdd.toyotaapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import org.apache.poi.hpsf.Decimal;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostPaymentsRequest implements Serializable{

    @JsonProperty("companyID")
    private Integer companyId;

    @JsonProperty("billingCode")
    private String billingCode;

    @JsonProperty("paymentDate")
    private String paymentDate;

    @JsonProperty("paymentValue")
    private BigDecimal paymentValue;

    @JsonProperty("agentCode")
    private String agentCode;

    public Integer getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Integer companyId) {
        this.companyId = companyId;
    }

    public String getBillingCode() {
        return billingCode;
    }

    public void setBillingCode(String billingCode) {
        this.billingCode = billingCode;
    }

    public String getPaymentDate() {
        return paymentDate;
    }

    public void setPaymentDate(String paymentDate) {
        this.paymentDate = paymentDate;
    }

    public BigDecimal getPaymentValue() {
        return paymentValue;
    }

    public void setPaymentValue(BigDecimal paymentValue) {
        this.paymentValue = paymentValue;
    }

    public String getAgentCode() {
        return agentCode;
    }

    public void setAgentCode(String agentCode) {
        this.agentCode = agentCode;
    }

    @Override
    public String toString() {
        return "PostPaymentsRequest [" +
                ((companyId != null) ? "companyId=" + companyId + ", " : "") +
                ((billingCode != null) ? "billingCode='" + billingCode + "', " : "") +
                ((paymentDate != null) ? "paymentDate='" + paymentDate + "', " : "") +
                ((paymentValue != null) ? "paymentValue=" + paymentValue + ", " : "") +
                ((agentCode != null) ? "agentCode='" + agentCode + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostPaymentsRequest that = (PostPaymentsRequest) o;
        return Objects.equals(companyId, that.companyId) && Objects.equals(billingCode, that.billingCode) && Objects.equals(paymentDate, that.paymentDate) && Objects.equals(paymentValue, that.paymentValue) && Objects.equals(agentCode, that.agentCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyId, billingCode, paymentDate, paymentValue, agentCode);
    }
}
