package ar.com.sdd.toyotaapi.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PostBillingListRequest implements Serializable {

    public final static String TYPE_OTROS = "Otros";
    public final static String TYPE_CUOTA_MENSUAL = "Cuota Mensual";

    @JsonProperty("group")
    private String group;

    @JsonProperty("quota")
    private Integer quota;

    @JsonProperty("type")
    private String type;

    public PostBillingListRequest() {
    }

    public PostBillingListRequest(String group, Integer quota, String type) {
        this.group = group;
        this.quota = quota;
        this.type = type;
    }

    public String getGroup() {
        return group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Integer getQuota() {
        return quota;
    }

    public void setQuota(Integer quota) {
        this.quota = quota;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "PostBillingListRequest [" +
                ((group != null) ? "group='" + group + "', " : "") +
                ((quota != null) ? "quota=" + quota + ", " : "") +
                ((type != null) ? "type='" + type + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PostBillingListRequest that = (PostBillingListRequest) o;
        return Objects.equals(group, that.group) && Objects.equals(quota, that.quota) && Objects.equals(type, that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(group, quota, type);
    }
}
