/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.toyotaapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.util.RestConnectorUtil;
import ar.com.sdd.toyotaapi.core.ToyotaApiConnectorContext;
import ar.com.sdd.toyotaapi.io.PostBillingListRequest;
import ar.com.sdd.toyotaapi.io.PostBillingListResponse;
import ar.com.sdd.toyotaapi.io.PostPaymentResponse;
import ar.com.sdd.toyotaapi.io.PostPaymentsRequest;
import javax.ws.rs.client.Invocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ToyotaApiConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(ToyotaApiConnector.class);
    private final RestConnector connector;
    private final String username;
    private final String password;
    private final String apiKey;

    public ToyotaApiConnector(ToyotaApiConnectorContext context) {
        this.username = context.getUsername();
        this.password = context.getPassword();
        this.apiKey = context.getApiKey();
        log.trace("Creando BindApiConnector con {}", (Object)context);
        RestConnectorEnvironment environment = new RestConnectorEnvironment(context.getBaseUrl());
        this.connector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public PostBillingListResponse postBillingList(PostBillingListRequest postBillingListRequest) throws RestConnectorException {
        log.debug("Iniciando exportacion de deuda con request={}", (Object)postBillingListRequest);
        return (PostBillingListResponse)this.connector.genericPost((Object)postBillingListRequest, PostBillingListResponse.class, "/quotas/billinglist");
    }

    public PostPaymentResponse postPayment(PostPaymentsRequest postPaymentsRequest) throws RestConnectorException {
        log.debug("Iniciando exportacion de pagos con request={}", (Object)postPaymentsRequest);
        return (PostPaymentResponse)this.connector.genericPost((Object)postPaymentsRequest, PostPaymentResponse.class, "/payments");
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (builder != null) {
            builder = builder.header("Authorization", (Object)RestConnectorUtil.getBasicAuthHeader((String)this.username, (String)this.password));
            builder = builder.header("X-TKNA", (Object)this.apiKey);
        }
        return builder;
    }

    public boolean retryOnUnauthorized() {
        return false;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }
}

