package ar.com.sdd.itauapi.api.transaction.notification;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.itauapi.model.Notification;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
@Path("/itauapi/v1_0/")
public class NotificationEndpoint {

    @Inject
    private NotificationService notificationService;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/transaction/notification")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postNotification(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, Notification notification, @Context SecurityContext securityContext) {
        return notificationService.notification(authorization, applicationId, ownerId,notification, securityContext);
    }
}