package ar.com.sdd.itauapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import javax.annotation.Generated;
import java.io.Serializable;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
        "clientId",
        "cuit",
        "holderName",
        "personType",
        "currency"
})
@Generated("jsonschema2pojo")
public class CvuTransaction implements Serializable
{

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CvuTransaction that = (CvuTransaction) o;

        if (clientId != null ? !clientId.equals(that.clientId) : that.clientId != null) return false;
        if (cuit != null ? !cuit.equals(that.cuit) : that.cuit != null) return false;
        if (holderName != null ? !holderName.equals(that.holderName) : that.holderName != null) return false;
        if (personType != null ? !personType.equals(that.personType) : that.personType != null) return false;
        if (currency != null ? !currency.equals(that.currency) : that.currency != null) return false;
        if (accountNumber != null ? !accountNumber.equals(that.accountNumber) : that.accountNumber != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = clientId != null ? clientId.hashCode() : 0;
        result = 31 * result + (cuit != null ? cuit.hashCode() : 0);
        result = 31 * result + (holderName != null ? holderName.hashCode() : 0);
        result = 31 * result + (personType != null ? personType.hashCode() : 0);
        result = 31 * result + (currency != null ? currency.hashCode() : 0);
        result = 31 * result + (accountNumber != null ? accountNumber.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "CvuTransaction [" +
                "clientId=" + clientId +
                ", cuit=" + cuit +
                ", holderName=" + holderName +
                ", personType=" + personType +
                ", currency=" + currency +
                ", accountNumber=" + accountNumber +
                ']';
    }

    private String clientId;  //minimum: 0;  maximum: 9999999999
    @JsonProperty("cuit")
    private String cuit;
    @JsonProperty("holderName")
    private String holderName;
    @JsonProperty("personType")
    private String personType;  //[ Fisica, Juridica ]
    @JsonProperty("currency")
    private String currency;  //ARS

    @JsonProperty("accountNumber")
    private String accountNumber; //No se usa inicialmente

    private final static long serialVersionUID = 8480690589992447244L;

    @JsonProperty("clientId")
    public String getClientId() {
        return clientId;
    }

    @JsonProperty("clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @JsonProperty("cuit")
    public String getCuit() {
        return cuit;
    }

    @JsonProperty("cuit")
    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    @JsonProperty("holderName")
    public String getHolderName() {
        return holderName;
    }

    @JsonProperty("holderName")
    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    @JsonProperty("personType")
    public String getPersonType() {
        return personType;
    }

    @JsonProperty("personType")
    public void setPersonType(String personType) {
        this.personType = personType;
    }

    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    @JsonProperty("currency")
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

}