package ar.com.sdd.itauapi.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.itauapi.io.TransactionResponse;
import ar.com.sdd.itauapi.model.CvuTransaction;
import ar.com.sdd.itauapi.model.Error;
import ar.com.sdd.itauapi.model.Transfer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.ws.rs.client.Invocation;
import java.util.HashMap;
import java.util.Map;

public class ItauApiConnector implements RestSecurityManager {

    private final static Logger log = LogManager.getLogger(ItauApiConnector.class);


    private final RestConnector restConnector;
    private final String cuitPSP;
    private final String keyValidationToken;


    public ItauApiConnector(ItauApiConnectorContext context) {
        String baseUrl = context.getBaseURL();
        cuitPSP = context.getCuitPSP();
        keyValidationToken = context.getKeyValidationToken();

        log.debug("Creando conector para ItauApiConnector con baseUrl [" + baseUrl + "], cuitPSP [" + cuitPSP + "]");

        RestConnectorEnvironment environment = new RestConnectorEnvironment(baseUrl, context.getKeystorePath(), context.getKeystorePass(), null, null);
        restConnector = new RestConnector(environment, this);

    }

    public TransactionResponse postCvu(CvuTransaction cvuTransaction) throws RestConnectorException {
        log.debug("[postCvu] Request POST cvuTransaction [" + cvuTransaction + "]");
        String path = "/apiCvu/v1/transaction/cvu/";
        TransactionResponse response =  restConnector.genericPost(cvuTransaction, TransactionResponse.class, Error.class, path);
        log.debug("[postCvu] Response POST cvu [" + response + "]");
        return response;
    }


    public TransactionResponse putCvu(String cvu, CvuTransaction cvuTransaction) throws RestConnectorException {
        log.debug("[putCvu] Req[" + cvuTransaction + "]");
        String path = "/apiCvu/v1/transaction/cvu/{cvu}";
        TransactionResponse response = restConnector.genericPut(cvuTransaction, TransactionResponse.class, Error.class, path, "cvu", cvu);
        log.debug("[putCvu] Res[" + response + "]");
        return response;
    }

    public TransactionResponse delCvu(String cvu, CvuTransaction cvuTransaction) throws RestConnectorException {
        log.debug("[delCvu] Req[" + cvuTransaction + "]");
        String path = "/apiCvu/v1/transaction/cvu/{cvu}";
        Map<String, Object> templateParameters = new HashMap<>();
        templateParameters.put("cvu", cvu);
        TransactionResponse response = restConnector.genericDelete(cvuTransaction,TransactionResponse.class, Error.class, path, templateParameters);
        log.debug("[delCvu] Res[" + response + "]");
        return response;
    }

    public TransactionResponse getCvu(String cvu)  throws RestConnectorException {
        log.debug("[getCvu] Req["+cvu+"]");
        String path = "/apiCvu/v1/transaction/cvu/{cvu}";
        TransactionResponse response = restConnector.genericGet(null,TransactionResponse.class, Error.class, path, "cvu", cvu);
        log.debug("[getCvu] Res[" + response + "]");
        return response;
    }



    public TransactionResponse postTransfer( Transfer transfer) throws RestConnectorException {
        log.debug("[postTransfer] Req[" + transfer + "]");
        String path = "/transfer/";
        TransactionResponse response = restConnector.genericPost(transfer, TransactionResponse.class, Error.class, path);
        log.debug("[postTransfer] Res[" + response + "]");
        return response;
    }


    public TransactionResponse getTransfer(String transferId)  throws RestConnectorException {
        log.debug("[getTransfer] Req["+transferId+"]");
        String path = "/transfer/{transferId}";
        TransactionResponse response = restConnector.genericGet(null,TransactionResponse.class, Error.class, path, "transferId", transferId);
        log.debug("[getTransfer] Res[" + response + "]");
        return response;
    }

    @Override
    public Invocation.Builder addHeaders(Invocation.Builder builder)  {
        builder.header("cuitPsp", cuitPSP);
        if (keyValidationToken!=null) {
            builder.header("keyValidationToken", keyValidationToken);
        }

        return builder;
    }

    @Override
    public boolean getDisableHTTPSErrors() {
        return false;
    }
}
