package ar.com.sdd.itauapi.io;

import ar.com.sdd.itauapi.model.Transaction;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class TransactionResponse {
    private Transaction transaction;
    private List<Error> errors;

    public Transaction getTransaction() {
        return transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public String toString() {
        return "TransactionResponse [" +
                "transaction=" + transaction +
                ", errors=" + (errors == null ? errors : Arrays.toString(errors.toArray())) +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TransactionResponse that = (TransactionResponse) o;

        if (!Objects.equals(transaction, that.transaction)) return false;
        return Objects.equals(errors, that.errors);
    }

    @Override
    public int hashCode() {
        int result = transaction != null ? transaction.hashCode() : 0;
        result = 31 * result + (errors != null ? errors.hashCode() : 0);
        return result;
    }
}
